/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.AnalysisException;

@Rule(key="S1451", name="Copyright and license headers should be defined", priority=Priority.BLOCKER, tags={})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class FileHeaderCheck
extends IssuableSubscriptionVisitor
implements CharsetAwareVisitor {
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final String MESSAGE = "Add or update the header of this file.";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Charset charset;
    private String[] expectedLines;
    private Pattern searchPattern = null;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (this.isRegularExpression) {
            if (this.searchPattern == null) {
                try {
                    this.searchPattern = Pattern.compile(this.headerFormat, 32);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
                }
            }
        } else {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
        this.visitFile(context.getFile());
    }

    public void visitFile(File file) {
        if (this.isRegularExpression) {
            String fileContent;
            try {
                fileContent = Files.toString((File)file, (Charset)this.charset);
            }
            catch (IOException e) {
                throw new AnalysisException((Throwable)e);
            }
            this.checkRegularExpression(fileContent);
        } else {
            List lines;
            try {
                lines = Files.readLines((File)file, (Charset)this.charset);
            }
            catch (IOException e) {
                throw new AnalysisException((Throwable)e);
            }
            if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
                this.addIssueOnFile(MESSAGE);
            }
        }
    }

    private void checkRegularExpression(String fileContent) {
        Matcher matcher = this.searchPattern.matcher(fileContent);
        if (!matcher.find() || matcher.start() != 0) {
            this.addIssueOnFile(MESSAGE);
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

