/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractForLoopRule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2252", name="Loop conditions should be true at least once", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ForLoopFalseConditionCheck
extends AbstractForLoopRule {
    @Override
    public void visitForStatement(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        if (condition != null && (ForLoopFalseConditionCheck.isAlwaysFalseCondition(condition) || ForLoopFalseConditionCheck.isConditionFalseAtInitialization(forStatement))) {
            this.reportIssue((Tree)condition, "This loop will never execute.");
        }
    }

    private static boolean isAlwaysFalseCondition(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return BooleanUtils.isFalse((Boolean)ForLoopFalseConditionCheck.booleanLiteralValue(expression));
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            ExpressionTree subExpression = ((UnaryExpressionTree)expression).expression();
            return BooleanUtils.isTrue((Boolean)ForLoopFalseConditionCheck.booleanLiteralValue(subExpression));
        }
        return false;
    }

    @CheckForNull
    private static Boolean booleanLiteralValue(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return Boolean.valueOf(((LiteralTree)expression).value());
        }
        return null;
    }

    private static boolean isConditionFalseAtInitialization(ForStatementTree forStatement) {
        Iterable<AbstractForLoopRule.ForLoopInitializer> initializers = AbstractForLoopRule.ForLoopInitializer.list(forStatement);
        ExpressionTree condition = forStatement.condition();
        if (!condition.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO})) {
            return false;
        }
        BinaryExpressionTree binaryCondition = (BinaryExpressionTree)condition;
        Integer leftOperand = ForLoopFalseConditionCheck.eval(binaryCondition.leftOperand(), initializers);
        Integer rightOperand = ForLoopFalseConditionCheck.eval(binaryCondition.rightOperand(), initializers);
        if (leftOperand != null && rightOperand != null) {
            return !ForLoopFalseConditionCheck.evaluateCondition(condition, leftOperand, rightOperand);
        }
        return false;
    }

    private static boolean evaluateCondition(ExpressionTree condition, int leftOperand, int rightOperand) {
        boolean conditionValue;
        switch (condition.kind()) {
            case GREATER_THAN: {
                conditionValue = leftOperand > rightOperand;
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                conditionValue = leftOperand >= rightOperand;
                break;
            }
            case LESS_THAN: {
                conditionValue = leftOperand < rightOperand;
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                conditionValue = leftOperand <= rightOperand;
                break;
            }
            default: {
                conditionValue = true;
            }
        }
        return conditionValue;
    }

    private static Integer eval(ExpressionTree expression, Iterable<AbstractForLoopRule.ForLoopInitializer> initializers) {
        Integer intLiteralValue = LiteralUtils.intLiteralValue((ExpressionTree)expression);
        if (intLiteralValue == null) {
            for (AbstractForLoopRule.ForLoopInitializer initializer : initializers) {
                if (!initializer.hasSameIdentifier(expression)) continue;
                intLiteralValue = initializer.value();
            }
        }
        return intLiteralValue;
    }
}

