/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1994", name="\"for\" loop incrementers should modify the variable being tested in the loop's stop condition", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ForLoopIncrementAndUpdateCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree forStatementTree;
        if (this.hasSemantic() && !(forStatementTree = (ForStatementTree)tree).update().isEmpty()) {
            Collection<Symbol> updateSymbols = ForLoopIncrementAndUpdateCheck.getUpdatedSymbols(forStatementTree);
            ConditionVisitor conditionVisitor = new ConditionVisitor(updateSymbols);
            forStatementTree.accept((TreeVisitor)conditionVisitor);
            if (conditionVisitor.shouldRaiseIssue) {
                this.reportIssue((Tree)forStatementTree.forKeyword(), "This loop's stop condition tests \"" + Joiner.on((String)", ").join((Iterable)conditionVisitor.conditionNames) + "\" but the incrementer updates \"" + ForLoopIncrementAndUpdateCheck.getSymbols(updateSymbols) + "\".");
            }
        }
    }

    private static Collection<Symbol> getUpdatedSymbols(ForStatementTree forStatementTree) {
        UpdateVisitor updateVisitor = new UpdateVisitor();
        forStatementTree.accept((TreeVisitor)updateVisitor);
        return updateVisitor.symbols;
    }

    private static String getSymbols(Collection<Symbol> updateSymbols) {
        ArrayList names = Lists.newArrayList();
        for (Symbol updateSymbol : updateSymbols) {
            names.add(updateSymbol.name());
        }
        return Joiner.on((String)", ").join((Iterable)names);
    }

    private static class ConditionVisitor
    extends BaseTreeVisitor {
        private final Collection<Symbol> updateSymbols;
        private final Collection<String> conditionNames;
        private boolean shouldRaiseIssue;

        ConditionVisitor(Collection<Symbol> updateSymbols) {
            this.updateSymbols = updateSymbols;
            this.conditionNames = Lists.newArrayList();
            this.shouldRaiseIssue = !updateSymbols.isEmpty();
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan((Tree)tree.condition());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mset = (MemberSelectExpressionTree)tree.methodSelect();
                ExpressionTree expression = mset.expression();
                if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    this.checkIdentifier((IdentifierTree)expression);
                } else {
                    this.checkIdentifier(mset.identifier());
                }
            } else {
                this.scan((Tree)tree.methodSelect());
            }
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.checkIdentifier(tree);
        }

        private void checkIdentifier(IdentifierTree tree) {
            Symbol reference = tree.symbol();
            String name = tree.name();
            if (reference.isMethodSymbol()) {
                name = name + "()";
            }
            this.conditionNames.add(name);
            if (this.updateSymbols.contains(reference)) {
                this.shouldRaiseIssue = false;
            }
        }
    }

    private static class UpdateVisitor
    extends BaseTreeVisitor {
        Collection<Symbol> symbols = Lists.newArrayList();

        private UpdateVisitor() {
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan(tree.update());
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkIdentifier(tree.expression());
            super.visitUnaryExpression(tree);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkIdentifier(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        private void checkIdentifier(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.addSymbol((IdentifierTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.addSymbol(((MemberSelectExpressionTree)expression).identifier());
            }
        }

        private void addSymbol(IdentifierTree identifierTree) {
            Symbol symbol = identifierTree.symbol();
            if (!symbol.isUnknown()) {
                this.symbols.add(symbol);
            }
        }
    }
}

