/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1488", name="Local Variables should not be declared and then immediately returned or thrown", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class ImmediatelyReturnedVariableCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<Tree.Kind, String> MESSAGE_KEYS = ImmutableMap.of((Object)Tree.Kind.THROW_STATEMENT, (Object)"throw", (Object)Tree.Kind.RETURN_STATEMENT, (Object)"return");
    private JavaFileScannerContext context;
    private String lastTypeForMessage;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        List statements = tree.body();
        int size = statements.size();
        if (size < 2) {
            return;
        }
        StatementTree butLastStatement = (StatementTree)statements.get(size - 2);
        if (butLastStatement.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            String identifier;
            VariableTree variableTree = (VariableTree)butLastStatement;
            StatementTree lastStatement = (StatementTree)statements.get(size - 1);
            String lastStatementIdentifier = this.getReturnOrThrowIdentifier(lastStatement);
            if (lastStatementIdentifier != null && StringUtils.equals((String)lastStatementIdentifier, (String)(identifier = variableTree.simpleName().name()))) {
                this.context.reportIssue((JavaCheck)this, (Tree)variableTree.initializer(), "Immediately " + this.lastTypeForMessage + " this expression instead of assigning it to the temporary variable \"" + identifier + "\".");
            }
        }
    }

    @CheckForNull
    private String getReturnOrThrowIdentifier(StatementTree lastStatementOfBlock) {
        this.lastTypeForMessage = null;
        ExpressionTree expr = null;
        if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.THROW_STATEMENT);
            expr = ((ThrowStatementTree)lastStatementOfBlock).expression();
        } else if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.RETURN_STATEMENT);
            expr = ((ReturnStatementTree)lastStatementOfBlock).expression();
        }
        if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expr).name();
        }
        return null;
    }
}

