/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S138", name="Methods should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class MethodTooBigCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 100;
    @RuleProperty(description="Maximum authorized lines in a method", defaultValue="100")
    public int max = 100;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        int lines;
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && (lines = MethodTooBigCheck.getLines(block)) > this.max) {
            this.reportIssue((Tree)methodTree.simpleName(), "This method has " + lines + " lines, which is greater than the " + this.max + " lines authorized. Split it into smaller methods.");
        }
    }

    private static int getLines(BlockTree block) {
        return 1 + block.closeBraceToken().line() - block.openBraceToken().line();
    }
}

