/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1161", name="\"@Override\" annotation should be used on any method overriding (since Java 5) or implementing (since Java 6) another one", priority=Priority.MAJOR, tags={"bad-practice"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class OverrideAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (OverrideAnnotationCheck.isOverriding(methodTree) && !methodTree.isAnnotatedOverride() && !OverrideAnnotationCheck.isExcluded(this.context.getJavaVersion(), methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Add the \"@Override\" annotation above this method signature");
        }
    }

    private static boolean isOverriding(MethodTreeImpl methodTree) {
        return BooleanUtils.isTrue((Boolean)methodTree.isOverriding());
    }

    private static boolean isExcluded(JavaVersion javaVersion, MethodTreeImpl methodTree) {
        if (javaVersion.isNotSet()) {
            return false;
        }
        int javaIntVersion = javaVersion.asInt();
        return javaIntVersion <= 4 || javaIntVersion == 5 && (methodTree.symbol().owner().isInterface() || OverrideAnnotationCheck.overrideFromInterface((MethodTree)methodTree));
    }

    private static boolean overrideFromInterface(MethodTree methodTree) {
        return ((JavaSymbol.MethodJavaSymbol)methodTree.symbol()).overriddenSymbol().owner().isInterface();
    }
}

