/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1905", name="Redundant casts should not be used", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class RedundantTypeCastCheck
extends IssuableSubscriptionVisitor {
    private Set<Tree> excluded = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excluded.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_CAST, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
            this.addArgsToExclusion(tree);
        } else {
            TypeCastTree typeCastTree = (TypeCastTree)tree;
            JavaType cast = (JavaType)typeCastTree.type().symbolType();
            ExpressionTree expression = typeCastTree.expression();
            if (RedundantTypeCastCheck.isChainedCastWithWildcard(typeCastTree)) {
                this.excluded.add((Tree)expression);
            }
            if (!this.excluded.contains(tree)) {
                JavaType expressionType = (JavaType)expression.symbolType();
                if (!RedundantTypeCastCheck.isExcluded(cast) && (RedundantTypeCastCheck.isRedundantNumericalCast(cast, expressionType) || RedundantTypeCastCheck.isRedundantCast(cast, expressionType))) {
                    this.reportIssue((Tree)typeCastTree.type(), "Remove this unnecessary cast to \"" + cast + "\".");
                }
            }
        }
    }

    private static boolean isChainedCastWithWildcard(TypeCastTree typeCastTree) {
        ExpressionTree expression = typeCastTree.expression();
        return expression.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST}) && RedundantTypeCastCheck.usesWildCard(expression);
    }

    private void addArgsToExclusion(Tree tree) {
        Arguments args;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            args = mit.arguments();
        } else {
            NewClassTree newClassTree = (NewClassTree)tree;
            args = newClassTree.arguments();
        }
        for (ExpressionTree arg : args) {
            if (!arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) continue;
            this.excluded.add((Tree)arg);
        }
    }

    private static boolean isExcluded(JavaType cast) {
        return cast.isUnknown();
    }

    private static boolean isRedundantCast(JavaType cast, JavaType expressionType) {
        JavaType erasedExpressionType = expressionType;
        if (erasedExpressionType.isTagged(15)) {
            erasedExpressionType = erasedExpressionType.erasure();
        }
        if (RedundantTypeCastCheck.isParametrizedType(cast) ^ RedundantTypeCastCheck.isParametrizedType(expressionType)) {
            return false;
        }
        if (RedundantTypeCastCheck.isParametrizedType(cast) && RedundantTypeCastCheck.isParametrizedType(expressionType)) {
            return expressionType.isSubtypeOf((Type)cast);
        }
        return erasedExpressionType.equals(cast) || !cast.isNumerical() && erasedExpressionType.isSubtypeOf((Type)cast);
    }

    private static boolean isParametrizedType(JavaType cast) {
        return cast instanceof JavaType.ParametrizedTypeJavaType;
    }

    private static boolean isRedundantNumericalCast(JavaType cast, JavaType expressionType) {
        return cast.isNumerical() && cast.equals(expressionType);
    }

    private static boolean usesWildCard(ExpressionTree expression) {
        WildCardFinder visitor = new WildCardFinder();
        expression.accept((TreeVisitor)visitor);
        return visitor.foundWildcard;
    }

    private static class WildCardFinder
    extends BaseTreeVisitor {
        private boolean foundWildcard = false;

        private WildCardFinder() {
        }

        public void visitWildcard(WildcardTree tree) {
            this.foundWildcard = true;
        }
    }
}

