/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2885", name="\"Calendars\" and \"DateFormats\" should not be static", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class StaticMultithreadedUnsafeFieldsCheck
extends IssuableSubscriptionVisitor {
    private static final String[] FORBIDDEN_TYPES = new String[]{"java.text.SimpleDateFormat", "java.util.Calendar", "javax.xml.xpath.XPath", "javax.xml.validation.SchemaFactory"};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        if (ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC) && StaticMultithreadedUnsafeFieldsCheck.isForbiddenType(variableTree.type().symbolType())) {
            IdentifierTree identifierTree = variableTree.simpleName();
            this.reportIssue((Tree)identifierTree, String.format("Make \"%s\" an instance variable.", identifierTree.name()));
        }
    }

    private static boolean isForbiddenType(Type type) {
        for (String name : FORBIDDEN_TYPES) {
            if (!type.isSubtypeOf(name)) continue;
            return true;
        }
        return false;
    }
}

