/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UselessParenthesesCheck", name="Useless parentheses around expressions should be removed to prevent any misunderstanding", priority=Priority.MAJOR, tags={"confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class UselessParenthesesCheck
extends IssuableSubscriptionVisitor {
    private final Deque<Tree> parent = new LinkedList<Tree>();
    private static final Tree.Kind[] PARENT_EXPRESSION = new Tree.Kind[]{Tree.Kind.ANNOTATION, Tree.Kind.LIST, Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.ARRAY_DIMENSION, Tree.Kind.ASSERT_STATEMENT, Tree.Kind.ASSIGNMENT, Tree.Kind.CASE_LABEL, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.DO_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION, Tree.Kind.ARGUMENTS, Tree.Kind.METHOD, Tree.Kind.NEW_ARRAY, Tree.Kind.NEW_CLASS, Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.RETURN_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SYNCHRONIZED_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.VARIABLE, Tree.Kind.WHILE_STATEMENT};

    public void scanFile(JavaFileScannerContext context) {
        this.parent.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) && this.hasParentExpression((ParenthesizedTree)tree)) {
            this.reportIssue((Tree)((ParenthesizedTree)tree).openParenToken(), "Remove those useless parentheses.", (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("Original", (Tree)((ParenthesizedTree)tree).closeParenToken())), null);
        }
        this.parent.push(tree);
    }

    private boolean hasParentExpression(ParenthesizedTree tree) {
        Tree parentTree = this.parent.peek();
        if (parentTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            return tree.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT}) || tree.expression() instanceof LiteralTree;
        }
        if (parentTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION}) && tree.equals(((ArrayAccessExpressionTree)parentTree).expression())) {
            return false;
        }
        return parentTree.is(PARENT_EXPRESSION);
    }

    public void leaveNode(Tree tree) {
        this.parent.pop();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.values());
    }
}

