/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2273", name="\"wait(...)\", \"notify()\" and \"notifyAll()\" methods should only be called when a lock is obviously held on an object", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class WaitInSynchronizeCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!this.isInSyncBlock()) {
            String lockName;
            IdentifierTree methodName;
            if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)mit.methodSelect();
                methodName = mse.identifier();
                lockName = mse.expression().symbolType().name();
            } else {
                methodName = (IdentifierTree)mit.methodSelect();
                lockName = "this";
            }
            this.reportIssue((Tree)methodName, "Make this call to \"" + methodName + "()\" only inside a synchronized block to be sure to hold the monitor on \"" + lockName + "\" object.");
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodMatcher.create().name("wait")).add((Object)MethodMatcher.create().name("wait").addParameter("long")).add((Object)MethodMatcher.create().name("wait").addParameter("long").addParameter("int")).add((Object)MethodMatcher.create().name("notify")).add((Object)MethodMatcher.create().name("notifyAll")).build();
    }
}

