/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1190", name="Future keywords should not be used as names", priority=Priority.MAJOR, tags={"obsolete", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="COMPILER_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class EnumAsIdentifierCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if ("enum".equals(simpleName.name())) {
            this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Use a different name than \"enum\".");
        }
        super.visitVariable(tree);
    }
}

