/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2057", name="\"Serializable\" classes should have a version id", priority=Priority.MAJOR, tags={"pitfall", "serialization"})
@SqaleSubCharacteristic(value="DATA_CHANGEABILITY")
@SqaleConstantRemediation(value="5min")
public class SerialVersionUidCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.visitClassTree((ClassTree)tree);
        }
    }

    private void visitClassTree(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null && SerialVersionUidCheck.isSerializable(symbol.type())) {
            Symbol.VariableSymbol serialVersionUidSymbol = SerialVersionUidCheck.findSerialVersionUid(symbol);
            if (serialVersionUidSymbol == null) {
                if (!SerialVersionUidCheck.isExclusion(symbol)) {
                    this.reportIssue((Tree)simpleName, "Add a \"static final long serialVersionUID\" field to this class.");
                }
            } else {
                this.checkModifiers(serialVersionUidSymbol);
            }
        }
    }

    private void checkModifiers(Symbol.VariableSymbol serialVersionUidSymbol) {
        VariableTree variableTree;
        ArrayList missingModifiers = Lists.newArrayList();
        if (!serialVersionUidSymbol.isStatic()) {
            missingModifiers.add("static");
        }
        if (!serialVersionUidSymbol.isFinal()) {
            missingModifiers.add("final");
        }
        if (!serialVersionUidSymbol.type().is("long")) {
            missingModifiers.add("long");
        }
        if ((variableTree = serialVersionUidSymbol.declaration()) != null && !missingModifiers.isEmpty()) {
            this.reportIssue((Tree)variableTree.simpleName(), "Make this \"serialVersionUID\" field \"" + Joiner.on((char)' ').join((Iterable)missingModifiers) + "\".");
        }
    }

    private static Symbol.VariableSymbol findSerialVersionUid(Symbol.TypeSymbol symbol) {
        for (Symbol member : symbol.lookupSymbols("serialVersionUID")) {
            if (!member.isVariableSymbol()) continue;
            return (Symbol.VariableSymbol)member;
        }
        return null;
    }

    private static boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean isExclusion(Symbol.TypeSymbol symbol) {
        return symbol.isAbstract() || symbol.type().isSubtypeOf("java.lang.Throwable") || SerialVersionUidCheck.isGuiClass((JavaSymbol.TypeJavaSymbol)symbol) || SerialVersionUidCheck.hasSuppressWarningAnnotation((JavaSymbol.TypeJavaSymbol)symbol);
    }

    private static boolean isGuiClass(JavaSymbol.TypeJavaSymbol symbol) {
        for (JavaType.ClassJavaType superType : symbol.superTypes()) {
            JavaSymbol.TypeJavaSymbol superTypeSymbol = superType.getSymbol();
            if (!SerialVersionUidCheck.hasGuiPackage(superTypeSymbol)) continue;
            return true;
        }
        return SerialVersionUidCheck.hasGuiPackage(symbol) || !symbol.equals(symbol.outermostClass()) && SerialVersionUidCheck.isGuiClass(symbol.outermostClass());
    }

    private static boolean hasGuiPackage(JavaSymbol.TypeJavaSymbol superTypeSymbol) {
        String fullyQualifiedName = superTypeSymbol.getFullyQualifiedName();
        return fullyQualifiedName.startsWith("javax.swing.") || fullyQualifiedName.startsWith("java.awt.");
    }

    private static boolean hasSuppressWarningAnnotation(JavaSymbol.TypeJavaSymbol symbol) {
        List annotations = symbol.metadata().valuesForAnnotation("java.lang.SuppressWarnings");
        if (annotations != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotations) {
                if (!"serial".equals(SerialVersionUidCheck.stringLiteralValue(annotationValue.value()))) continue;
                return true;
            }
        }
        return false;
    }

    private static String stringLiteralValue(Object object) {
        if (object instanceof LiteralTree) {
            LiteralTree literal = (LiteralTree)object;
            return LiteralUtils.trimQuotes((String)literal.value());
        }
        return null;
    }
}

