/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2924", name="JUnit rules should be used", priority=Priority.MAJOR, tags={"unused", "junit"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedTestRuleCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> CHECKED_RULE = ImmutableSet.of((Object)"org.junit.rules.TemporaryFolder", (Object)"org.junit.rules.TestName");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            VariableTree variableTree;
            Symbol symbol;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !UnusedTestRuleCheck.isTestNameOrTemporaryFolderRule(symbol = (variableTree = (VariableTree)member).symbol()) || !symbol.usages().isEmpty()) continue;
            this.reportIssue((Tree)variableTree.simpleName(), "Remove this unused \"" + symbol.type() + "\".");
        }
    }

    private static boolean isTestNameOrTemporaryFolderRule(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith("org.junit.Rule") && CHECKED_RULE.contains(symbol.type().fullyQualifiedName());
    }
}

