/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3340", name="Annotation arguments should appear in the order in which they were declared", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class AnnotationArgumentOrderCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotationTree = (AnnotationTree)tree;
        Symbol.TypeSymbol annotationSymbol = annotationTree.symbolType().symbol();
        if (annotationSymbol.isUnknown()) {
            return;
        }
        ArrayList<String> declarationNames = new ArrayList<String>();
        for (Symbol symbol : annotationSymbol.memberSymbols()) {
            declarationNames.add(symbol.name());
        }
        ArrayList<String> annotationArguments = new ArrayList<String>();
        for (ExpressionTree argument : annotationTree.arguments()) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) continue;
            AssignmentExpressionTree assignmentTree = (AssignmentExpressionTree)argument;
            IdentifierTree nameTree = (IdentifierTree)assignmentTree.variable();
            annotationArguments.add(nameTree.name());
        }
        declarationNames.retainAll(annotationArguments);
        if (!declarationNames.equals(annotationArguments)) {
            this.reportIssue((Tree)annotationTree.annotationType(), "Reorder annotation arguments to match the order of declaration.");
        }
    }
}

