/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1195", name="Array designators \"[]\" should be located after the type in method signatures", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayDesignatorAfterTypeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        TypeTree returnType = methodTree.returnType();
        SyntaxToken identifierToken = methodTree.simpleName().identifierToken();
        while (returnType.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)returnType;
            SyntaxToken openBracketToken = arrayTypeTree.openBracketToken();
            if (ArrayDesignatorAfterTypeCheck.isInvalidPosition(openBracketToken, identifierToken)) {
                this.reportIssue((Tree)openBracketToken, "Move the array designators \"[]\" to the end of the return type.");
                break;
            }
            returnType = arrayTypeTree.type();
        }
    }

    private static boolean isInvalidPosition(SyntaxToken openBracketToken, SyntaxToken identifierToken) {
        return identifierToken.line() < openBracketToken.line() || identifierToken.line() == openBracketToken.line() && identifierToken.column() < openBracketToken.column();
    }
}

