/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Objects;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2970", name="Assertions should be complete", priority=Priority.CRITICAL, tags={"bug", "tests"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class AssertionsCompletenessCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String FEST_ASSERT_SUPERTYPE = "org.fest.assertions.Assert";
    private static final String ASSERTJ_SUPERTYPE = "org.assertj.core.api.AbstractAssert";
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withNoParameterConstraint();
    private static final MethodMatcherCollection FEST_LIKE_ASSERT_THAT = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractStandardSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.StrictAssertions")});
    private static final MethodMatcherCollection FEST_LIKE_EXCLUSIONS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"overridingErrorMessage")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"overridingErrorMessage"))});
    private Boolean chainedToAnyMethodButFestExclusions = null;
    private JavaFileScannerContext context;

    private static MethodMatcher assertThatOnType(String type) {
        return MethodMatcher.create().typeDefinition(type).name("assertThat").addParameter(TypeCriteria.anyType());
    }

    private static MethodMatcher methodWithName(String superType, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)superType)).name(nameCriteria).withNoParameterConstraint();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (this.incompleteAssertion(mit)) {
            return;
        }
        Boolean previous = this.chainedToAnyMethodButFestExclusions;
        this.chainedToAnyMethodButFestExclusions = (Boolean)Objects.firstNonNull((Object)this.chainedToAnyMethodButFestExclusions, (Object)false) != false || !FEST_LIKE_EXCLUSIONS.anyMatch(mit);
        this.scan((Tree)mit.methodSelect());
        this.chainedToAnyMethodButFestExclusions = previous;
    }

    private boolean incompleteAssertion(MethodInvocationTree mit) {
        if ((FEST_LIKE_ASSERT_THAT.anyMatch(mit) && mit.arguments().size() == 1 || MOCKITO_VERIFY.matches(mit)) && !Boolean.TRUE.equals(this.chainedToAnyMethodButFestExclusions)) {
            this.context.reportIssue((JavaCheck)this, (Tree)mit.methodSelect(), "Complete the assertion.");
            return true;
        }
        return false;
    }
}

