/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2638", name="Method overrides should not change contracts", priority=Priority.MAJOR, tags={"suspicious"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class ChangeMethodContractCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVAX_ANNOTATION_CHECK_FOR_NULL = "javax.annotation.CheckForNull";
    private static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    private static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        JavaSymbol.MethodJavaSymbol overridee = ((JavaSymbol.MethodJavaSymbol)methodSymbol).overriddenSymbol();
        if (overridee != null && overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTreeImpl methodTree, JavaSymbol.MethodJavaSymbol overridee) {
        if (methodTree.isEqualsMethod() && ((VariableTree)methodTree.parameters().get(0)).symbol().metadata().isAnnotatedWith(JAVAX_ANNOTATION_NONNULL)) {
            this.reportIssue((Tree)methodTree.parameters().get(0), "Equals method should accept null parameters and return false.");
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            VariableTree parameter = (VariableTree)methodTree.parameters().get(i);
            Symbol overrideeParamSymbol = (Symbol)overridee.getParameters().scopeSymbols().get(i);
            this.checkParameter(parameter, overrideeParamSymbol);
        }
        if (ChangeMethodContractCheck.nonNullVsNull((Symbol)overridee, (Symbol)methodTree.symbol())) {
            for (AnnotationTree annotationTree : methodTree.modifiers().annotations()) {
                if (!annotationTree.symbolType().is(JAVAX_ANNOTATION_NULLABLE) && !annotationTree.symbolType().is(JAVAX_ANNOTATION_CHECK_FOR_NULL)) continue;
                this.reportIssue((Tree)annotationTree, "Remove this \"" + annotationTree.symbolType().name() + "\" annotation to honor the overridden method's contract.");
            }
        }
    }

    private void checkParameter(VariableTree parameter, Symbol overrideeParamSymbol) {
        VariableTree reportTree = parameter;
        if (ChangeMethodContractCheck.nonNullVsNull(parameter.symbol(), overrideeParamSymbol)) {
            for (AnnotationTree annotationTree : parameter.modifiers().annotations()) {
                if (!annotationTree.symbolType().is(JAVAX_ANNOTATION_NONNULL)) continue;
                reportTree = annotationTree;
            }
            this.reportIssue((Tree)reportTree, "Remove this \"Nonnull\" annotation to honor the overridden method's contract.");
        }
    }

    private static boolean nonNullVsNull(Symbol sym1, Symbol sym2) {
        return sym1.metadata().isAnnotatedWith(JAVAX_ANNOTATION_NONNULL) && (sym2.metadata().isAnnotatedWith(JAVAX_ANNOTATION_NULLABLE) || sym2.metadata().isAnnotatedWith(JAVAX_ANNOTATION_CHECK_FOR_NULL));
    }
}

