/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1699", name="Constructors should only call non-overridable methods", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ConstructorCallingOverridableCheck
extends IssuableSubscriptionVisitor {
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        JavaSymbol.TypeJavaSymbol constructorType;
        if (this.hasSemantic() && !(constructorType = (JavaSymbol.TypeJavaSymbol)this.semanticModel.getEnclosingClass(tree)).isFinal()) {
            ((MethodTree)tree).block().accept((TreeVisitor)new ConstructorBodyVisitor(constructorType));
        }
    }

    private class ConstructorBodyVisitor
    extends BaseTreeVisitor {
        private JavaSymbol.TypeJavaSymbol constructorType;

        public ConstructorBodyVisitor(JavaSymbol.TypeJavaSymbol constructorType) {
            this.constructorType = constructorType;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol;
            IdentifierTree methodIdentifier = null;
            boolean isInvocationOnSelf = false;
            ExpressionTree methodSelect = tree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                methodIdentifier = (IdentifierTree)methodSelect;
                isInvocationOnSelf = !this.isThisOrSuper((ExpressionTree)methodIdentifier);
            } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
                methodIdentifier = memberSelect.identifier();
                isInvocationOnSelf = this.isThis(memberSelect.expression());
            }
            if (isInvocationOnSelf && this.isOverridableMethod(symbol = methodIdentifier.symbol()) && this.isMethodDefinedOnConstructedType(symbol)) {
                ConstructorCallingOverridableCheck.this.reportIssue((Tree)methodIdentifier, "Remove this call from a constructor to the overridable \"" + methodIdentifier.name() + "\" method.");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean is(ExpressionTree expression, String match) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                String targetName = ((IdentifierTree)expression).name();
                return match.equals(targetName);
            }
            return false;
        }

        private boolean isThis(ExpressionTree expression) {
            return this.is(expression, "this");
        }

        private boolean isThisOrSuper(ExpressionTree expression) {
            return this.is(expression, "this") || this.is(expression, "super");
        }

        private boolean isMethodDefinedOnConstructedType(Symbol symbol) {
            JavaSymbol.TypeJavaSymbol methodEnclosingClass = (JavaSymbol.TypeJavaSymbol)symbol.enclosingClass();
            for (JavaType.ClassJavaType superType : this.constructorType.superTypes()) {
                if (!superType.getSymbol().equals(methodEnclosingClass)) continue;
                return true;
            }
            return this.constructorType.equals(methodEnclosingClass);
        }

        private boolean isOverridableMethod(Symbol symbol) {
            return symbol.isMethodSymbol() && !symbol.isPrivate() && !symbol.isFinal() && !symbol.isStatic();
        }
    }
}

