/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3066", name="\"enum\" fields should not be publicly mutable", priority=Priority.CRITICAL, tags={"bad-practice", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="20min")
public class EnumMutableFieldCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree enumTree = (ClassTree)tree;
        for (Tree member : enumTree.members()) {
            MethodTree methodTree;
            ModifierKeywordTree publicModifier;
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                ModifiersTree modifiers = ((VariableTree)member).modifiers();
                publicModifier = ModifiersUtils.getModifier((ModifiersTree)modifiers, (Modifier)Modifier.PUBLIC);
                if (publicModifier == null || ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC) || ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.FINAL)) continue;
                this.reportIssue((Tree)publicModifier, "Lower the visibility of this field.");
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || (publicModifier = ModifiersUtils.getModifier((ModifiersTree)(methodTree = (MethodTree)member).modifiers(), (Modifier)Modifier.PUBLIC)) == null || !EnumMutableFieldCheck.isSetter(methodTree)) continue;
            this.reportIssue((Tree)publicModifier, "Lower the visibility of this setter or remove it altogether.");
        }
    }

    private static boolean isSetter(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        BlockTree block = methodTree.block();
        boolean returnsVoid = returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        boolean hasAtLeastOneStatement = block == null || !block.body().isEmpty();
        return methodTree.simpleName().name().startsWith("set") && methodTree.parameters().size() == 1 && returnsVoid && hasAtLeastOneStatement;
    }
}

