/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2201", name="Return values should not be ignored when function calls don't have any side effects", priority=Priority.CRITICAL, tags={"bug", "cert", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class IgnoredReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> CHECKED_TYPES = ImmutableList.builder().add((Object)"java.lang.String").add((Object)"java.lang.Boolean").add((Object)"java.lang.Integer").add((Object)"java.lang.Double").add((Object)"java.lang.Float").add((Object)"java.lang.Byte").add((Object)"java.lang.Character").add((Object)"java.lang.Short").add((Object)"java.lang.StackTraceElement").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        Type methodType;
        ExpressionStatementTree est = (ExpressionStatementTree)tree;
        if (est.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !IgnoredReturnValueCheck.returnsVoid(methodType = (mit = (MethodInvocationTree)est.expression()).symbolType()) && IgnoredReturnValueCheck.isCheckedType(mit)) {
            IdentifierTree methodName = MethodsHelper.methodName(mit);
            this.reportIssue((Tree)methodName, "The return value of \"" + methodName.name() + "\" must be used.");
        }
    }

    private static boolean isCheckedType(MethodInvocationTree mit) {
        Symbol owner = mit.symbol().owner();
        for (String type : CHECKED_TYPES) {
            if (!owner.type().is(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsVoid(Type methodType) {
        return methodType.isVoid() || methodType.isUnknown();
    }
}

