/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2153", name="Boxing and unboxing should not be immediately reversed", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class ImmediateReverseBoxingCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> PRIMITIVE_TYPES_BY_WRAPPER = ImmutableMap.builder().put((Object)"java.lang.Boolean", (Object)"boolean").put((Object)"java.lang.Byte", (Object)"byte").put((Object)"java.lang.Double", (Object)"double").put((Object)"java.lang.Float", (Object)"float").put((Object)"java.lang.Integer", (Object)"int").put((Object)"java.lang.Long", (Object)"long").put((Object)"java.lang.Short", (Object)"short").put((Object)"java.lang.Character", (Object)"char").build();
    private static final MethodMatcherCollection unboxingInvocationMatchers = ImmediateReverseBoxingCheck.unboxingInvocationMatchers();
    private static final MethodMatcherCollection valueOfInvocationMatchers = ImmediateReverseBoxingCheck.valueOfInvocationMatchers();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitMethodInvocationTree((MethodInvocationTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                ExpressionTree initializer = variableTree.initializer();
                if (initializer != null) {
                    this.checkExpression(initializer, variableTree.type().symbolType());
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree assignmentTree = (AssignmentExpressionTree)tree;
                this.checkExpression(assignmentTree.expression(), assignmentTree.symbolType());
            } else {
                NewClassTree newClassTree = (NewClassTree)tree;
                Symbol.TypeSymbol classSymbol = ImmediateReverseBoxingCheck.wrapperClassSymbol(newClassTree);
                if (classSymbol != null) {
                    this.checkForUnboxing((ExpressionTree)newClassTree.arguments().get(0));
                }
            }
        }
    }

    private void checkExpression(ExpressionTree expression, Type implicitType) {
        if (implicitType.isPrimitive()) {
            this.checkForBoxing(expression);
        } else {
            this.checkForUnboxing(expression);
        }
    }

    private void visitMethodInvocationTree(MethodInvocationTree methodInvocationTree) {
        if (ImmediateReverseBoxingCheck.isValueOfInvocation(methodInvocationTree)) {
            this.checkForUnboxing((ExpressionTree)methodInvocationTree.arguments().get(0));
        } else if (ImmediateReverseBoxingCheck.isUnboxingMethodInvocation(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                this.checkForBoxing(memberSelectExpressionTree.expression());
            }
        } else {
            Symbol symbol = methodInvocationTree.symbol();
            if (symbol.isMethodSymbol()) {
                List parametersTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
                this.checkMethodInvocationArguments(methodInvocationTree, parametersTypes);
            }
        }
    }

    private void checkMethodInvocationArguments(MethodInvocationTree methodInvocationTree, List<Type> parametersTypes) {
        Arguments arguments = methodInvocationTree.arguments();
        int position = 0;
        for (Type paramType : parametersTypes) {
            if (arguments.size() > position) {
                this.checkExpression((ExpressionTree)arguments.get(position), paramType);
            }
            ++position;
        }
    }

    private void checkForBoxing(ExpressionTree expression) {
        MethodInvocationTree methodInvocationTree;
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            ExpressionTree boxingArg;
            NewClassTree newClassTree = (NewClassTree)expression;
            Symbol.TypeSymbol classSymbol = ImmediateReverseBoxingCheck.wrapperClassSymbol(newClassTree);
            if (classSymbol != null && (boxingArg = (ExpressionTree)newClassTree.arguments().get(0)).symbolType().isPrimitive()) {
                this.addBoxingIssue((Tree)newClassTree, (Symbol)classSymbol, (Tree)boxingArg);
            }
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ImmediateReverseBoxingCheck.isValueOfInvocation(methodInvocationTree = (MethodInvocationTree)expression)) {
            ExpressionTree boxingArg = (ExpressionTree)methodInvocationTree.arguments().get(0);
            this.addBoxingIssue((Tree)expression, methodInvocationTree.symbol().owner(), (Tree)boxingArg);
        }
    }

    private static Symbol.TypeSymbol wrapperClassSymbol(NewClassTree newClassTree) {
        Symbol.TypeSymbol classSymbol = newClassTree.symbolType().symbol();
        if (PRIMITIVE_TYPES_BY_WRAPPER.containsKey(newClassTree.symbolType().fullyQualifiedName()) && !newClassTree.arguments().isEmpty()) {
            return classSymbol;
        }
        return null;
    }

    private void addBoxingIssue(Tree tree, Symbol classSymbol, Tree boxingArg) {
        if (boxingArg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)boxingArg;
            this.reportIssue(tree, "Remove the boxing of \"" + identifier.name() + "\".");
        } else {
            this.reportIssue(tree, "Remove the boxing to \"" + classSymbol.name() + "\".");
        }
    }

    private void checkForUnboxing(ExpressionTree expressionTree) {
        if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
        if (ImmediateReverseBoxingCheck.isUnboxingMethodInvocation(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                ExpressionTree unboxedExpression = memberSelectExpressionTree.expression();
                String unboxingResultTypeName = methodInvocationTree.symbolType().fullyQualifiedName();
                if (unboxingResultTypeName.equals(PRIMITIVE_TYPES_BY_WRAPPER.get(unboxedExpression.symbolType().fullyQualifiedName()))) {
                    this.addUnboxingIssue(expressionTree, unboxedExpression);
                }
            }
        }
    }

    private void addUnboxingIssue(ExpressionTree expressionTree, ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)expression;
            this.reportIssue((Tree)expressionTree, "Remove the unboxing of \"" + identifier.name() + "\".");
        } else {
            String name = expression.symbolType().name();
            this.reportIssue((Tree)expressionTree, "Remove the unboxing from \"" + name + "\".");
        }
    }

    private static MethodMatcherCollection unboxingInvocationMatchers() {
        MethodMatcherCollection matchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        for (Map.Entry<String, String> type : PRIMITIVE_TYPES_BY_WRAPPER.entrySet()) {
            String primitiveType = type.getValue();
            TypeCriteria typeCriteria = "char".equals(primitiveType) || "boolean".equals(primitiveType) ? TypeCriteria.is((String)type.getKey()) : TypeCriteria.subtypeOf((String)"java.lang.Number");
            matchers.add(MethodMatcher.create().callSite(typeCriteria).name(primitiveType + "Value"));
        }
        return matchers;
    }

    private static MethodMatcherCollection valueOfInvocationMatchers() {
        MethodMatcherCollection matchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        for (Map.Entry<String, String> primitiveMapping : PRIMITIVE_TYPES_BY_WRAPPER.entrySet()) {
            matchers.add(MethodMatcher.create().typeDefinition(primitiveMapping.getKey()).name("valueOf").addParameter(primitiveMapping.getValue()));
        }
        return matchers;
    }

    private static boolean isUnboxingMethodInvocation(MethodInvocationTree mit) {
        return unboxingInvocationMatchers.anyMatch(mit);
    }

    private static boolean isValueOfInvocation(MethodInvocationTree mit) {
        return valueOfInvocationMatchers.anyMatch(mit);
    }
}

