/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2912", name="\"indexOf\" checks should use a start position", priority=Priority.MAJOR, tags={"confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class IndexOfStartPositionCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatcher INDEX_OF_METHOD = MethodMatcher.create().typeDefinition("java.lang.String").name("indexOf").addParameter("java.lang.String");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO, (Object)Tree.Kind.LESS_THAN, (Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO, (Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        ExpressionTree leftOperand = ExpressionsHelper.skipParentheses(((BinaryExpressionTree)tree).leftOperand());
        ExpressionTree rightOperand = ExpressionsHelper.skipParentheses(((BinaryExpressionTree)tree).rightOperand());
        if (leftOperand.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.checkIndexOfInvocation((MethodInvocationTree)leftOperand, rightOperand);
        } else if (rightOperand.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.checkIndexOfInvocation((MethodInvocationTree)rightOperand, leftOperand);
        }
    }

    private void checkIndexOfInvocation(MethodInvocationTree mit, ExpressionTree other) {
        if (INDEX_OF_METHOD.matches(mit)) {
            ExpressionTree firstPar = (ExpressionTree)mit.arguments().get(0);
            String replaceMessage = firstPar.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? ((LiteralTree)firstPar).value() : (firstPar.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? ((IdentifierTree)firstPar).name() : "xxx");
            Long otherValue = LiteralUtils.longLiteralValue((ExpressionTree)other);
            if (otherValue != null && otherValue != -1L && otherValue != 0L) {
                this.reportIssue((Tree)MethodsHelper.methodName(mit), "Use \".indexOf(" + replaceMessage + ",n) > -1\" instead.");
            }
        }
    }
}

