/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2197", name="Modulus results should not be checked for direct equality", priority=Priority.CRITICAL, tags={"bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ModulusEqualityCheck
extends IssuableSubscriptionVisitor {
    private List<Symbol> methodParams = Lists.newArrayList();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.methodParams.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            BinaryExpressionTree equality = (BinaryExpressionTree)tree;
            this.checkModulusAndIntLiteral(equality.leftOperand(), equality.rightOperand());
            this.checkModulusAndIntLiteral(equality.rightOperand(), equality.leftOperand());
        } else {
            MethodTree methodTree = (MethodTree)tree;
            for (VariableTree variableTree : methodTree.parameters()) {
                this.methodParams.add(variableTree.symbol());
            }
        }
    }

    private void checkModulusAndIntLiteral(ExpressionTree operand1, ExpressionTree operand2) {
        if (operand1.is(new Tree.Kind[]{Tree.Kind.REMAINDER})) {
            boolean usesSize;
            BinaryExpressionTree modulusExp = (BinaryExpressionTree)operand1;
            Integer intValue = LiteralUtils.intLiteralValue((ExpressionTree)operand2);
            ExpressionTree leftOperand = modulusExp.leftOperand();
            ExpressionTree rightOperand = modulusExp.rightOperand();
            boolean usesMethodParam = this.isMethodParameter(leftOperand) || this.isMethodParameter(rightOperand);
            boolean bl = usesSize = ModulusEqualityCheck.isSizeAccessor(leftOperand) || ModulusEqualityCheck.isSizeAccessor(rightOperand);
            if (intValue != null && intValue != 0 && usesMethodParam && !usesSize) {
                String sign = intValue > 0 ? "positive" : "negative";
                this.reportIssue((Tree)modulusExp.operatorToken(), "The results of this modulus operation may not be " + sign + ".");
            }
        }
    }

    private boolean isMethodParameter(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)expressionTree;
            Symbol symbol = identifier.symbol();
            return this.methodParams.contains(symbol);
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expressionTree;
            return this.isMethodParameter(memberSelectExpressionTree.expression());
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
            return this.isMethodParameter(methodInvocationTree.methodSelect());
        }
        return false;
    }

    private static boolean isSizeAccessor(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            String memberName;
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expressionTree;
            Type type = memberSelectExpressionTree.expression().symbolType();
            return ModulusEqualityCheck.isCollectionSize(type, memberName = memberSelectExpressionTree.identifier().name()) || ModulusEqualityCheck.isStringLength(type, memberName) || ModulusEqualityCheck.isArrayLength(type, memberName);
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
            return ModulusEqualityCheck.isSizeAccessor(methodInvocationTree.methodSelect());
        }
        return false;
    }

    private static boolean isArrayLength(Type type, String memberName) {
        return type.isArray() && "length".equals(memberName);
    }

    private static boolean isStringLength(Type type, String memberName) {
        return type.is("java.lang.String") && "length".equals(memberName);
    }

    private static boolean isCollectionSize(Type type, String memberName) {
        return type.isSubtypeOf("java.util.Collection") && "size".equals(memberName);
    }
}

