/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Locale;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2681", name="Multiline blocks should be enclosed in curly braces", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class MultilineBlocksCurlyBracesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String LOOP_MESSAGE = "Only the first line of this %d-line block will be executed in a loop. The rest will execute only once.";
    private static final String IF_MESSAGE = "Only the first line of this %d-line block will be executed conditionally. The rest will execute unconditionally.";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        StatementTree previous = null;
        for (StatementTree current : tree.body()) {
            if (previous != null) {
                this.check(current, previous);
            }
            previous = current;
        }
    }

    private void check(StatementTree current, StatementTree previous) {
        StatementTree block = null;
        boolean condition = false;
        if (previous.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
            block = ((ForEachStatement)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            block = ((ForStatementTree)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) {
            block = ((WhileStatementTree)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            block = MultilineBlocksCurlyBracesCheck.getIfStatementLastBlock(previous);
            condition = true;
        }
        if (block != null && !block.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            SyntaxToken previousToken = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)block);
            int previousColumn = previousToken.column();
            int previousLine = previousToken.line();
            SyntaxToken currentToken = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)current);
            int currentColumn = currentToken.column();
            int currentLine = currentToken.line();
            if (previousColumn == currentColumn) {
                this.context.reportIssue((JavaCheck)this, (Tree)current, String.format(Locale.US, condition ? IF_MESSAGE : LOOP_MESSAGE, 1 + currentLine - previousLine));
            }
        }
    }

    private static StatementTree getIfStatementLastBlock(StatementTree statementTree) {
        StatementTree block = statementTree;
        while (block.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatementTree = (IfStatementTree)block;
            StatementTree elseStatement = ifStatementTree.elseStatement();
            block = elseStatement == null ? ifStatementTree.thenStatement() : elseStatement;
        }
        return block;
    }
}

