/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2258", name="\"javax.crypto.NullCipher\" should not be used for anything other than testing", priority=Priority.BLOCKER, tags={"cwe", "owasp-a6", "sans-top25-porous", "security"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="15min")
public class NullCipherCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        if (newClassTree.symbolType().is("javax.crypto.NullCipher")) {
            this.reportIssue((Tree)newClassTree.identifier(), "Remove this use of the \"NullCipher\" class.");
        }
    }
}

