/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S864", name="Limited dependence should be placed on operator precedence rules in expressions", priority=Priority.MAJOR, tags={"cert", "cwe", "misra"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class OperatorPrecedenceCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Table<Tree.Kind, Tree.Kind, Boolean> OPERATORS_RELATION_TABLE;
    private static final Set<Tree.Kind> ARITHMETIC_OPERATORS;
    private static final Set<Tree.Kind> EQUALITY_RELATIONAL_OPERATORS;
    private static final Set<Tree.Kind> SHIFT_OPERATORS;
    private static final Tree.Kind[] CONDITIONAL_EXCLUSIONS;
    private JavaFileScannerContext context;
    private Deque<Tree.Kind> stack = new LinkedList<Tree.Kind>();
    private Set<Integer> reportedLines = new HashSet<Integer>();

    private static void put(Iterable<Tree.Kind> firstSet, Iterable<Tree.Kind> secondSet) {
        for (Tree.Kind first : firstSet) {
            for (Tree.Kind second : secondSet) {
                OPERATORS_RELATION_TABLE.put((Object)first, (Object)second, (Object)true);
            }
        }
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.reportedLines.clear();
        this.scan((Tree)context.getTree());
        this.reportedLines.clear();
    }

    public void visitAnnotation(AnnotationTree tree) {
        this.stack.push(null);
        for (ExpressionTree argument : tree.arguments()) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                this.scan((Tree)((AssignmentExpressionTree)argument).expression());
                continue;
            }
            this.scan((Tree)argument);
        }
        this.stack.pop();
    }

    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan((Tree)tree.expression());
        this.stack.push(null);
        this.scan((Tree)tree.dimension());
        this.stack.pop();
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Tree.Kind kind;
        Tree.Kind peek = this.stack.peek();
        if (OperatorPrecedenceCheck.requiresParenthesis(peek, kind = tree.kind())) {
            this.raiseIssue(tree.operatorToken().line(), (Tree)tree);
        }
        this.stack.push(kind);
        super.visitBinaryExpression(tree);
        this.stack.pop();
    }

    private static boolean requiresParenthesis(Tree.Kind kind1, Tree.Kind kind2) {
        return BooleanUtils.isTrue((Boolean)((Boolean)OPERATORS_RELATION_TABLE.get((Object)kind1, (Object)kind2)));
    }

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        ExpressionTree condition = tree.condition();
        if (condition.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && EQUALITY_RELATIONAL_OPERATORS.contains(((AssignmentExpressionTree)condition).expression().kind())) {
            this.raiseIssue(((AssignmentExpressionTree)condition).operatorToken().line(), (Tree)tree);
        }
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.scan((Tree)tree.methodSelect());
        this.scan((ListTree)tree.typeArguments());
        for (ExpressionTree argument : tree.arguments()) {
            this.stack.push(null);
            this.scan((Tree)argument);
            this.stack.pop();
        }
    }

    public void visitNewArray(NewArrayTree tree) {
        this.stack.push(null);
        super.visitNewArray(tree);
        this.stack.pop();
    }

    public void visitNewClass(NewClassTree tree) {
        this.stack.push(null);
        super.visitNewClass(tree);
        this.stack.pop();
    }

    public void visitParenthesized(ParenthesizedTree tree) {
        this.stack.push(null);
        super.visitParenthesized(tree);
        this.stack.pop();
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.checkConditionalOperand(tree.trueExpression());
        this.checkConditionalOperand(tree.falseExpression());
        super.visitConditionalExpression(tree);
    }

    private void checkConditionalOperand(ExpressionTree tree) {
        if (!(tree.is(CONDITIONAL_EXCLUSIONS) || tree instanceof LiteralTree || tree instanceof UnaryExpressionTree)) {
            this.raiseIssue(FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree).line(), (Tree)tree);
        }
    }

    private void raiseIssue(int line, Tree tree) {
        if (this.reportedLines.add(line)) {
            this.context.reportIssue((JavaCheck)this, tree, "Add parentheses to make the operator precedence explicit.");
        }
    }

    static {
        ARITHMETIC_OPERATORS = EnumSet.of(Tree.Kind.MINUS, Tree.Kind.REMAINDER, Tree.Kind.MULTIPLY, Tree.Kind.PLUS);
        EQUALITY_RELATIONAL_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO});
        SHIFT_OPERATORS = EnumSet.of(Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT);
        CONDITIONAL_EXCLUSIONS = new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.TYPE_CAST, Tree.Kind.NEW_CLASS, Tree.Kind.ARRAY_ACCESS_EXPRESSION};
        OPERATORS_RELATION_TABLE = HashBasedTable.create();
        OperatorPrecedenceCheck.put(ARITHMETIC_OPERATORS, Iterables.concat(SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(SHIFT_OPERATORS, Iterables.concat(ARITHMETIC_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.AND), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.XOR), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.OR), Iterables.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.CONDITIONAL_AND), EnumSet.of(Tree.Kind.CONDITIONAL_OR));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.CONDITIONAL_OR), EnumSet.of(Tree.Kind.CONDITIONAL_AND));
    }
}

