/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2675", name="\"readObject\" should not be \"synchronized\"", priority=Priority.MAJOR, tags={"confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class ReadObjectSynchronizedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (ReadObjectSynchronizedCheck.implementsSerializable(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                this.checkMember((MethodTree)member);
            }
        }
    }

    private void checkMember(MethodTree member) {
        ModifierKeywordTree modifier;
        if (ReadObjectSynchronizedCheck.isReadObject(member) && (modifier = ModifiersUtils.getModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.SYNCHRONIZED)) != null) {
            this.reportIssue((Tree)modifier.keyword(), "Remove the \"synchronized\" keyword from this method.");
        }
    }

    private static boolean implementsSerializable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean isReadObject(MethodTree methodTree) {
        if (!"readObject".equals(methodTree.simpleName().name())) {
            return false;
        }
        return methodTree.parameters().size() == 1 && ((VariableTree)methodTree.parameters().get(0)).type().symbolType().is("java.io.ObjectInputStream");
    }
}

