/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2444", name="Lazy initialization of \"static\" fields should be \"synchronized\"", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class StaticFieldInitializationCheck
extends AbstractInSynchronizeChecker {
    private Deque<Boolean> withinStaticInitializer = new LinkedList<Boolean>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.SYNCHRONIZED_STATEMENT, (Object)Tree.Kind.STATIC_INITIALIZER);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.withinStaticInitializer.push(false);
        super.scanFile(context);
        this.withinStaticInitializer.clear();
    }

    @Override
    public void visitNode(Tree tree) {
        IdentifierTree variable;
        AssignmentExpressionTree aet;
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (aet = (AssignmentExpressionTree)tree).variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !this.isInSyncBlock() && !this.withinStaticInitializer.peek().booleanValue() && StaticFieldInitializationCheck.isStaticNotVolatileObject(variable = (IdentifierTree)aet.variable())) {
            this.reportIssue((Tree)variable, "Synchronize this lazy initialization of '" + variable.name() + "'");
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            this.withinStaticInitializer.push(true);
        }
        super.visitNode(tree);
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            this.withinStaticInitializer.pop();
        }
        super.leaveNode(tree);
    }

    private static boolean isStaticNotVolatileObject(IdentifierTree variable) {
        Symbol symbol = variable.symbol();
        if (symbol.isUnknown()) {
            return false;
        }
        return StaticFieldInitializationCheck.isStaticNotFinalNotVolatile(symbol) && !symbol.type().isPrimitive();
    }

    private static boolean isStaticNotFinalNotVolatile(Symbol symbol) {
        return symbol.isStatic() && !symbol.isVolatile() && !symbol.isFinal();
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of();
    }
}

