/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1192", name="String literals should not be duplicated", priority=Priority.MINOR, tags={"design"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleLinearWithOffsetRemediation(coeff="2min", offset="2min", effortToFixDescription="per duplicate instance")
public class StringLiteralDuplicatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final Integer MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    private final Multimap<String, LiteralTree> occurrences = ArrayListMultimap.create();

    public void scanFile(JavaFileScannerContext context) {
        this.occurrences.clear();
        this.scan((Tree)context.getTree());
        for (String entry : this.occurrences.keySet()) {
            Collection literalTrees = this.occurrences.get((Object)entry);
            int literalOccurence = literalTrees.size();
            if (literalOccurence < this.threshold) continue;
            ArrayList<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree element : literalTrees) {
                flow.add(new JavaFileScannerContext.Location("Duplication", element));
            }
            context.reportIssue((JavaCheck)this, (Tree)Iterables.getFirst((Iterable)literalTrees, null), "Define a constant instead of duplicating this literal " + entry + " " + literalOccurence + " times.", flow, Integer.valueOf(literalOccurence));
        }
    }

    public void visitLiteral(LiteralTree tree) {
        String literal;
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (literal = tree.value()).length() >= MINIMAL_LITERAL_LENGTH) {
            this.occurrences.put((Object)literal, (Object)tree);
        }
    }

    public void visitMethod(MethodTree tree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.DEFAULT)) {
            return;
        }
        super.visitMethod(tree);
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }
}

