/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1191", name="Classes from \"sun.*\" packages should not be used", priority=Priority.MAJOR, tags={"lock-in", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="COMPILER_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="1h")
public class SunPackagesUsedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private Set<Integer> reportedLines = new HashSet<Integer>();
    private static final String DEFAULT_EXCLUDE = "";
    @RuleProperty(key="Exclude", description="Comma separated list of Sun packages to be ignored by this rule. Example: com.sun.jna,sun.misc", defaultValue="")
    public String exclude = "";
    private String[] excludePackages = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.reportedLines.clear();
        this.excludePackages = this.exclude.split(",");
        this.scan((Tree)context.getTree());
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        String reference = ExpressionsHelper.concatenate((ExpressionTree)tree);
        if (!this.isExcluded(reference)) {
            int line = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree).line();
            if (!this.reportedLines.contains(line) && SunPackagesUsedCheck.isSunClass(reference)) {
                this.context.addIssue(line, (JavaCheck)this, "Replace this usage of Sun classes by ones from the Java API.");
                this.reportedLines.add(line);
            }
            super.visitMemberSelectExpression(tree);
        }
    }

    private static boolean isSunClass(String reference) {
        return "com.sun".equals(reference) || reference.matches("sun\\.[^\\.]*");
    }

    private boolean isExcluded(String reference) {
        for (String str : this.excludePackages) {
            if (str.isEmpty() || !reference.startsWith(str)) continue;
            return true;
        }
        return false;
    }
}

