/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1219", name="\"switch\" statements should not contain non-case labels", priority=Priority.MAJOR, tags={"misra", "suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class SwitchWithLabelsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CASE_GROUP);
    }

    public void visitNode(Tree tree) {
        CaseGroupTree cgt = (CaseGroupTree)tree;
        for (StatementTree statementTree : cgt.body()) {
            if (!statementTree.is(new Tree.Kind[]{Tree.Kind.LABELED_STATEMENT})) continue;
            IdentifierTree label = ((LabeledStatementTree)statementTree).label();
            this.reportIssue((Tree)label, "Remove this misleading \"" + label.name() + "\" label.");
        }
    }
}

