/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S106", name="Standard outputs should not be used directly to log anything", priority=Priority.MAJOR, tags={"bad-practice"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ERRORS")
@SqaleConstantRemediation(value="10min")
public class SystemOutOrErrUsageCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.MEMBER_SELECT);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree mset = (MemberSelectExpressionTree)tree;
        if (SystemOutOrErrUsageCheck.isOutOrErr(mset) && SystemOutOrErrUsageCheck.isSystem(mset.expression())) {
            this.reportIssue(tree, "Replace this usage of System.out or System.err by a logger.");
        }
    }

    private static boolean isSystem(ExpressionTree expression) {
        IdentifierTree identifierTree = null;
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifierTree = (IdentifierTree)expression;
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            identifierTree = ((MemberSelectExpressionTree)expression).identifier();
        }
        return identifierTree != null && "System".equals(identifierTree.name());
    }

    private static boolean isOutOrErr(MemberSelectExpressionTree mset) {
        return "out".equals(mset.identifier().name()) || "err".equals(mset.identifier().name());
    }
}

