/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2236", name="Methods \"wait(...)\", \"notify()\" and \"notifyAll()\" should never be called on Thread instances", priority=Priority.BLOCKER, tags={"bug", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ThreadWaitCallCheck
extends AbstractMethodDetection {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Refactor the synchronisation mechanism to not use a Thread instance as a monitor");
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        TypeCriteria subtypeOfThread = TypeCriteria.subtypeOf((String)"java.lang.Thread");
        return ImmutableList.builder().add((Object)MethodMatcher.create().callSite(subtypeOfThread).name("wait")).add((Object)MethodMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long")).add((Object)MethodMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long").addParameter("int")).add((Object)MethodMatcher.create().callSite(subtypeOfThread).name("notify")).add((Object)MethodMatcher.create().callSite(subtypeOfThread).name("notifyAll")).build();
    }
}

