/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00104", name="Files should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1h")
public class TooManyLinesOfCodeInFileCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 1000;
    @RuleProperty(key="Max", description="Maximum authorized lines in a file.", defaultValue="1000")
    public int maximum = 1000;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitToken(SyntaxToken token) {
        int lines;
        if (((InternalSyntaxToken)token).isEOF() && (lines = token.line()) > this.maximum) {
            this.addIssueOnFile(MessageFormat.format("This file has {0} lines, which is greater than {1} authorized. Split it into smaller files.", lines, this.maximum));
        }
    }
}

