/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2062", name="\"readResolve\" methods should be inheritable", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class PrivateReadResolveCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree method = (MethodTree)tree;
        if (PrivateReadResolveCheck.isPrivateReadResolve(method) && PrivateReadResolveCheck.isOwnedBySerializableExtensibleClass(method)) {
            this.reportIssue((Tree)method.simpleName(), "Make this class \"private\" or elevate the visibility of \"readResolve\".");
        }
    }

    private static boolean isPrivateReadResolve(MethodTree method) {
        return "readResolve".equals(method.simpleName().name()) && method.parameters().isEmpty() && ModifiersUtils.hasModifier((ModifiersTree)method.modifiers(), (Modifier)Modifier.PRIVATE);
    }

    private static boolean isOwnedBySerializableExtensibleClass(MethodTree method) {
        Symbol owner = method.symbol().owner();
        return !owner.isPrivate() && !owner.isFinal() && owner.type().isSubtypeOf("java.io.Serializable");
    }
}

