/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2221", name="\"Exception\" should not be caught when not required by called methods", priority=Priority.CRITICAL, tags={"cwe", "error-handling", "security"})
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="15min")
public class CatchExceptionCheck
extends IssuableSubscriptionVisitor {
    private final ThrowsExceptionVisitor throwsExceptionVisitor = new ThrowsExceptionVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        TryStatementTree tryStatement = (TryStatementTree)tree;
        for (CatchTree catchTree : tryStatement.catches()) {
            TypeTree catchType = catchTree.parameter().type();
            if (!this.catchesException(catchType, tryStatement.block())) continue;
            this.reportIssue((Tree)catchType, "Catch a list of specific exception subtypes instead.");
        }
    }

    private boolean catchesException(TypeTree catchType, BlockTree block) {
        if (catchType.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            UnionTypeTree unionTypeTree = (UnionTypeTree)catchType;
            for (TypeTree typeAlternative : unionTypeTree.typeAlternatives()) {
                if (!this.catchesExceptionCheck(block, typeAlternative)) continue;
                return true;
            }
        } else if (this.catchesExceptionCheck(block, catchType)) {
            return true;
        }
        return false;
    }

    private boolean catchesExceptionCheck(BlockTree block, TypeTree catchType) {
        return CatchExceptionCheck.isJavaLangException(catchType.symbolType()) && !this.throwsExceptionVisitor.containsExplicitThrowsException((Tree)block);
    }

    private static boolean isJavaLangException(Type type) {
        return type.is("java.lang.Exception");
    }

    private static class ThrowsExceptionVisitor
    extends BaseTreeVisitor {
        private boolean containsExplicitThrowsException;

        private ThrowsExceptionVisitor() {
        }

        boolean containsExplicitThrowsException(Tree tree) {
            this.containsExplicitThrowsException = false;
            tree.accept((TreeVisitor)this);
            return this.containsExplicitThrowsException;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.containsExplicitThrowsException) {
                return;
            }
            Symbol symbol = tree.symbol();
            if (symbol.isUnknown()) {
                this.containsExplicitThrowsException = true;
                return;
            }
            for (Type type : ((Symbol.MethodSymbol)symbol).thrownTypes()) {
                if (!CatchExceptionCheck.isJavaLangException(type)) continue;
                this.containsExplicitThrowsException = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }
    }
}

