/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2114", name="Collections should not be passed as arguments to their own methods", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class CollectionCallingItselfCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            Symbol symbolReference = null;
            Symbol method = null;
            String reportedName = "";
            if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)methodInvocationTree.methodSelect();
                IdentifierTree identifier = mse.identifier();
                reportedName = identifier.name();
                method = identifier.symbol();
                if (mse.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    symbolReference = ((IdentifierTree)mse.expression()).symbol();
                }
            }
            if (symbolReference != null && CollectionCallingItselfCheck.isMethodFromCollection(method)) {
                this.reportIssueForParameters(methodInvocationTree, symbolReference, reportedName);
            }
        }
    }

    private void reportIssueForParameters(MethodInvocationTree methodInvocationTree, Symbol symbolReference, String reportedName) {
        for (ExpressionTree arg : methodInvocationTree.arguments()) {
            Symbol reference;
            if (!arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || (reference = ((IdentifierTree)arg).symbol()) != symbolReference) continue;
            this.reportIssue((Tree)methodInvocationTree, "Remove or correct this \"" + reportedName + "\" call.");
        }
    }

    private static boolean isMethodFromCollection(Symbol methodSymbol) {
        if (!methodSymbol.isMethodSymbol()) {
            return false;
        }
        Type ownerType = methodSymbol.owner().type();
        return !ownerType.is("java.util.Collection") && ownerType.isSubtypeOf("java.util.Collection");
    }
}

