/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3306", name="Constructor injection should be used instead of field injection", priority=Priority.MAJOR, tags={"design", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ConstructorInjectionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        List members = ((ClassTree)tree).members();
        List<MethodTree> constructors = ConstructorInjectionCheck.filterByKind(members, Tree.Kind.CONSTRUCTOR);
        for (MethodTree constructor : constructors) {
            if (!ConstructorInjectionCheck.isPrivateConstructor(constructor)) continue;
            return;
        }
        List<VariableTree> fields = ConstructorInjectionCheck.filterByKind(members, Tree.Kind.VARIABLE);
        for (VariableTree field : fields) {
            if (!ConstructorInjectionCheck.isAnnotatedWithInject(field)) continue;
            this.reportIssue((Tree)field.simpleName(), "Use constructor injection for this field.");
        }
    }

    private static boolean isPrivateConstructor(MethodTree constructor) {
        return constructor.symbol().isPrivate();
    }

    private static boolean isAnnotatedWithInject(VariableTree field) {
        return field.symbol().metadata().isAnnotatedWith("javax.inject.Inject");
    }

    private static <X extends Tree> List<X> filterByKind(List<? extends Tree> list, final Tree.Kind kind) {
        ArrayList<? extends Tree> filteredList = new ArrayList<Tree>(list);
        CollectionUtils.filter(filteredList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((Tree)object).is(new Tree.Kind[]{kind});
            }
        });
        return filteredList;
    }
}

