/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1210", name="\"equals(Object obj)\" should be overridden along with the \"compareTo(T obj)\" method", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class EqualsNotOverridenWithCompareToCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> EXCLUDED_ANNOTATIONS_TYPE = ImmutableList.builder().add((Object)"lombok.EqualsAndHashCode").add((Object)"lombok.Data").add((Object)"lombok.Value").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (EqualsNotOverridenWithCompareToCheck.isComparable(classTree)) {
            boolean hasEquals = false;
            MethodTree compare = null;
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                MethodTree method = (MethodTree)member;
                if (EqualsNotOverridenWithCompareToCheck.isEqualsMethod(method)) {
                    hasEquals = true;
                    continue;
                }
                if (!EqualsNotOverridenWithCompareToCheck.isCompareToMethod(method)) continue;
                compare = method;
            }
            if (compare != null && !hasEquals && !EqualsNotOverridenWithCompareToCheck.generatesEquals(classTree)) {
                this.reportIssue((Tree)compare.simpleName(), "Override \"equals(Object obj)\" to comply with the contract of the \"compareTo(T o)\" method.");
            }
        }
    }

    private static boolean generatesEquals(ClassTree classTree) {
        SymbolMetadata metadata = classTree.symbol().metadata();
        for (String annotation : EXCLUDED_ANNOTATIONS_TYPE) {
            if (!metadata.isAnnotatedWith(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompareToMethod(MethodTree method) {
        String name = method.simpleName().name();
        return "compareTo".equals(name) && EqualsNotOverridenWithCompareToCheck.returnsInt(method) && method.parameters().size() == 1;
    }

    private static boolean isEqualsMethod(MethodTree method) {
        return ((MethodTreeImpl)method).isEqualsMethod();
    }

    private static boolean isComparable(ClassTree tree) {
        for (Type type : tree.symbol().interfaces()) {
            if (!type.is("java.lang.Comparable")) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsInt(MethodTree tree) {
        TypeTree typeTree = tree.returnType();
        return typeTree != null && typeTree.symbolType().isPrimitive(Type.Primitives.INT);
    }
}

