/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1165", name="Exception classes should be immutable", priority=Priority.MAJOR, tags={"error-handling"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="15min")
public class ExceptionsShouldBeImmutableCheck
extends IssuableSubscriptionVisitor {
    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (ExceptionsShouldBeImmutableCheck.isException(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || ExceptionsShouldBeImmutableCheck.isFinal((VariableTree)member)) continue;
                IdentifierTree simpleName = ((VariableTree)member).simpleName();
                this.reportIssue((Tree)simpleName, "Make this \"" + simpleName.name() + "\" field final.");
            }
        }
    }

    private static boolean isFinal(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isException(ClassTree classTree) {
        return classTree.simpleName() != null && classTree.symbol().type().isSubtypeOf("java.lang.Throwable");
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }
}

