/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00121", name="Control structures should use curly braces", priority=Priority.MAJOR, tags={"cert", "misra", "pitfall"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class MissingCurlyBracesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.FOR_EACH_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.DO_STATEMENT);
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case WHILE_STATEMENT: {
                WhileStatementTree whileStatementTree = (WhileStatementTree)tree;
                this.checkStatement(whileStatementTree.whileKeyword(), whileStatementTree.statement());
                break;
            }
            case DO_STATEMENT: {
                DoWhileStatementTree doWhileStatementTree = (DoWhileStatementTree)tree;
                this.checkStatement(doWhileStatementTree.doKeyword(), doWhileStatementTree.statement());
                break;
            }
            case FOR_STATEMENT: {
                ForStatementTree forStatementTree = (ForStatementTree)tree;
                this.checkStatement(forStatementTree.forKeyword(), forStatementTree.statement());
                break;
            }
            case FOR_EACH_STATEMENT: {
                ForEachStatement forEachStatement = (ForEachStatement)tree;
                this.checkStatement(forEachStatement.forKeyword(), forEachStatement.statement());
                break;
            }
            case IF_STATEMENT: {
                this.checkIfStatement((IfStatementTree)tree);
                break;
            }
        }
    }

    private void checkIfStatement(IfStatementTree ifStmt) {
        this.checkStatement(ifStmt.ifKeyword(), ifStmt.thenStatement());
        StatementTree elseStmt = ifStmt.elseStatement();
        if (elseStmt != null && !elseStmt.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkStatement(ifStmt.elseKeyword(), elseStmt);
        }
    }

    private void checkStatement(SyntaxToken reportToken, StatementTree statement) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.reportIssue((Tree)reportToken, "Missing curly brace.");
        }
    }
}

