/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2187", name="TestCases should contain tests", priority=Priority.MAJOR, tags={"confusing", "tests", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class NoTestInTestClassCheck
extends IssuableSubscriptionVisitor {
    private static final Predicate<SymbolMetadata.AnnotationInstance> PREDICATE_ANNOTATION_TEST_OR_UNKNOWN = new Predicate<SymbolMetadata.AnnotationInstance>(){

        public boolean apply(SymbolMetadata.AnnotationInstance input) {
            Type type = input.symbol().type();
            return type.isUnknown() || type.is("org.junit.Test") || type.is("org.testng.annotations.Test");
        }
    };

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            CompilationUnitTree cut = (CompilationUnitTree)tree;
            for (Tree typeTree : cut.types()) {
                if (!typeTree.is(new Tree.Kind[]{Tree.Kind.CLASS})) continue;
                this.checkClass((ClassTree)typeTree);
            }
        }
    }

    private void checkClass(ClassTree classTree) {
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            JavaSymbol.TypeJavaSymbol symbol = (JavaSymbol.TypeJavaSymbol)classTree.symbol();
            Iterable<Symbol> members = NoTestInTestClassCheck.getAllMembers(symbol);
            IdentifierTree simpleName = classTree.simpleName();
            if (classTree.symbol().metadata().isAnnotatedWith("org.testng.annotations.Test")) {
                this.checkTestNGmembers(simpleName, members);
            } else {
                boolean isJunit3TestClass = symbol.type().isSubtypeOf("junit.framework.TestCase");
                if (isJunit3TestClass) {
                    this.checkJunit3TestClass(simpleName, members);
                } else {
                    this.checkJunit4TestClass(simpleName, symbol, members);
                }
            }
        }
    }

    private void checkTestNGmembers(IdentifierTree className, Iterable<Symbol> members) {
        for (Symbol member : members) {
            if (!member.isMethodSymbol() || !member.isPublic() || member.isStatic() || ((Symbol.MethodSymbol)member).returnType() == null) continue;
            return;
        }
        this.reportIssue((Tree)className, "Add some tests to this class.");
    }

    private void checkJunit3TestClass(IdentifierTree className, Iterable<Symbol> members) {
        this.checkMethods(className, members, false);
    }

    private void checkJunit4TestClass(IdentifierTree className, JavaSymbol.TypeJavaSymbol symbol, Iterable<Symbol> members) {
        if (symbol.name().endsWith("Test") && !NoTestInTestClassCheck.runWithEnclosedRunner(symbol)) {
            this.checkMethods(className, members, true);
        }
    }

    private static boolean runWithEnclosedRunner(JavaSymbol.TypeJavaSymbol symbol) {
        List annotationValues = symbol.metadata().valuesForAnnotation("org.junit.runner.RunWith");
        if (annotationValues != null && annotationValues.size() == 1) {
            Object value = ((SymbolMetadata.AnnotationValue)annotationValues.get(0)).value();
            return value instanceof MemberSelectExpressionTree && ExpressionsHelper.concatenate((ExpressionTree)value).endsWith("Enclosed.class");
        }
        return false;
    }

    private void checkMethods(IdentifierTree simpleName, Iterable<Symbol> members, boolean forJunit4) {
        for (Symbol member : members) {
            if (!member.isMethodSymbol() || !NoTestInTestClassCheck.isTestMethod(forJunit4, member)) continue;
            return;
        }
        this.reportIssue((Tree)simpleName, "Add some tests to this class.");
    }

    private static boolean isTestMethod(boolean forJunit4, Symbol member) {
        if (forJunit4) {
            return Iterables.any((Iterable)member.metadata().annotations(), PREDICATE_ANNOTATION_TEST_OR_UNKNOWN);
        }
        return member.name().startsWith("test");
    }

    private static Iterable<Symbol> getAllMembers(JavaSymbol.TypeJavaSymbol symbol) {
        Iterable members = symbol.memberSymbols();
        JavaType superclass = symbol.getSuperclass();
        while (superclass != null && !"java.lang.Object".equals(superclass.fullyQualifiedName())) {
            members = Iterables.concat((Iterable)members, (Iterable)superclass.symbol().memberSymbols());
            superclass = superclass.getSymbol().getSuperclass();
        }
        return members;
    }
}

