/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1175", name="The signature of \"finalize()\" should match that of \"Object.finalize()\"", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ObjectFinalizeOverloadedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverloadedCheck.isFinalizeOverload(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Rename this method to avoid any possible confusion with Object.finalize().");
        }
    }

    private static boolean isFinalizeOverload(MethodTree methodTree) {
        return "finalize".equals(methodTree.simpleName().name()) && !methodTree.parameters().isEmpty();
    }
}

