/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2156", name="\"final\" classes should not have \"protected\" members", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ProtectedMemberInFinalClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.FINAL)) {
            for (Tree member : classTree.members()) {
                this.checkMember(member);
            }
        }
    }

    private void checkMember(Tree member) {
        MethodTreeImpl methodTree;
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)member;
            this.checkMemberModifier(variableTree.modifiers());
        } else if (member.is(new Tree.Kind[]{Tree.Kind.METHOD}) && BooleanUtils.isFalse((Boolean)(methodTree = (MethodTreeImpl)member).isOverriding())) {
            this.checkMemberModifier(methodTree.modifiers());
        }
    }

    private void checkMemberModifier(ModifiersTree modifiers) {
        ModifierKeywordTree modifier = ModifiersUtils.getModifier((ModifiersTree)modifiers, (Modifier)Modifier.PROTECTED);
        if (modifier != null) {
            this.reportIssue((Tree)modifier.keyword(), "Remove this \"protected\" modifier.");
        }
    }
}

