/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2140", name="Methods of \"Random\" that return floating point values should not be used in random integer generation", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class RandomFloatToIntCheck
extends IssuableSubscriptionVisitor {
    private final MethodMatcherCollection methodMatchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.Random").name("nextDouble"), MethodMatcher.create().typeDefinition("java.util.Random").name("nextFloat"), MethodMatcher.create().typeDefinition("java.lang.Math").name("random")});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        TypeCastTree castTree = (TypeCastTree)tree;
        if (castTree.type().symbolType().is("int")) {
            castTree.expression().accept((TreeVisitor)new RandomDoubleVisitor());
        }
    }

    private class RandomDoubleVisitor
    extends BaseTreeVisitor {
        private RandomDoubleVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (RandomFloatToIntCheck.this.methodMatchers.anyMatch(tree)) {
                RandomFloatToIntCheck.this.reportIssue((Tree)tree.methodSelect(), "Use \"java.util.Random.nextInt()\" instead.");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            this.scan((Tree)tree.enclosingExpression());
            this.scan((Tree)tree.identifier());
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
        }
    }
}

