/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1905", name="Redundant casts should not be used", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class RedundantTypeCastCheck
extends IssuableSubscriptionVisitor {
    private Set<Tree> excluded = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excluded.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        Type cast = typeCastTree.type().symbolType();
        Type target = RedundantTypeCastCheck.targetType(typeCastTree);
        Type expressionType = typeCastTree.expression().symbolType();
        if (target != null && (RedundantTypeCastCheck.isRedundantNumericalCast(cast, expressionType) || RedundantTypeCastCheck.isSubtype(expressionType, target))) {
            this.reportIssue((Tree)typeCastTree.type(), "Remove this unnecessary cast to \"" + cast + "\".");
        }
    }

    @CheckForNull
    private static Type targetType(TypeCastTree tree) {
        Tree parent = RedundantTypeCastCheck.skipParentheses(tree.parent());
        Type target = null;
        if (parent.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            Tree method = parent;
            while (!method.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION})) {
                method = method.parent();
            }
            target = method.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) ? null : ((JavaType.MethodJavaType)((MethodTree)method).symbol().type()).resultType();
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)parent;
            target = variableTree.symbol().type();
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)parent;
            if (mit.symbol().isMethodSymbol()) {
                JavaSymbol.MethodJavaSymbol sym = (JavaSymbol.MethodJavaSymbol)mit.symbol();
                int castArgIndex = mit.arguments().indexOf((Object)tree);
                target = (Type)sym.parameterTypes().get(castArgIndex);
            }
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT, Tree.Kind.CONDITIONAL_EXPRESSION})) {
            target = tree.type().symbolType();
        } else if (parent instanceof ExpressionTree) {
            target = ((ExpressionTree)parent).symbolType();
        }
        return target;
    }

    private static Tree skipParentheses(Tree parent) {
        Tree skip = parent;
        while (skip.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            skip = skip.parent();
        }
        return skip;
    }

    private static boolean isSubtype(Type expression, Type target) {
        return expression.isSubtypeOf(target);
    }

    private static boolean isRedundantNumericalCast(Type cast, Type expressionType) {
        return cast.isNumerical() && cast.equals(expressionType);
    }
}

