/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2437", name="Silly bit operations should not be performed", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SillyBitOperationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.XOR, (Object)Tree.Kind.XOR_ASSIGNMENT, (Object)Tree.Kind.AND, (Object)Tree.Kind.AND_ASSIGNMENT, (Object)Tree.Kind.OR, (Object)Tree.Kind.OR_ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        SyntaxToken operatorToken;
        ExpressionTree expression;
        if (tree.is(new Tree.Kind[]{Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.AND})) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            expression = binary.rightOperand();
            operatorToken = binary.operatorToken();
        } else {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
            expression = assignment.expression();
            operatorToken = assignment.operatorToken();
        }
        Long evaluatedExpression = LiteralUtils.longLiteralValue((ExpressionTree)expression);
        if (evaluatedExpression != null && SillyBitOperationCheck.getBitwiseOperationIdentityElement(tree).equals(evaluatedExpression)) {
            this.reportIssue((Tree)operatorToken, "Remove this silly bit operation.");
        }
    }

    private static Long getBitwiseOperationIdentityElement(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.AND_ASSIGNMENT})) {
            return -1L;
        }
        return 0L;
    }
}

