/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2129", name="Constructors should not be used to instantiate \"String\" and primitive-wrapper classes", priority=Priority.MAJOR, tags={"performance"})
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class StringPrimitiveConstructorCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final String INIT = "<init>";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(STRING).name(INIT), (Object)MethodMatcher.create().typeDefinition(STRING).name(INIT).addParameter(STRING), (Object)MethodMatcher.create().typeDefinition("java.lang.Byte").name(INIT).addParameter("byte"), (Object)MethodMatcher.create().typeDefinition("java.lang.Character").name(INIT).addParameter("char"), (Object)MethodMatcher.create().typeDefinition("java.lang.Short").name(INIT).addParameter("short"), (Object)MethodMatcher.create().typeDefinition("java.lang.Integer").name(INIT).addParameter("int"), (Object)MethodMatcher.create().typeDefinition("java.lang.Long").name(INIT).addParameter("long"), (Object)MethodMatcher.create().typeDefinition("java.lang.Float").name(INIT).addParameter("float"), (Object)MethodMatcher.create().typeDefinition("java.lang.Double").name(INIT).addParameter("double"), (Object)MethodMatcher.create().typeDefinition("java.lang.Boolean").name(INIT).addParameter("boolean"));
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree.identifier(), "Remove this \"" + newClassTree.symbolType().name() + "\" constructor");
    }
}

