/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TrailingCommentCheck", name="Comments should not be located at the end of lines of code", priority=Priority.INFO, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommentCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^\\s*+[^\\s]++$";
    private static final Set<String> EXCLUDED_PATTERNS = ImmutableSet.of((Object)"NOSONAR", (Object)"NOPMD", (Object)"CHECKSTYLE:");
    @RuleProperty(key="legalTrailingCommentPattern", description="Description Pattern for text of trailing comments that are allowed. By default, comments containing only one word.", defaultValue="^\\s*+[^\\s]++$")
    public String legalCommentPattern = "^\\s*+[^\\s]++$";
    private Pattern pattern;
    private boolean ignoreMultipleOccurences;
    private Set<SyntaxToken> visitedTokens;
    private int previousTokenLine;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN, (Object)Tree.Kind.VARIABLE);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
        this.visitedTokens = Sets.newHashSet();
        super.scanFile(context);
        this.visitedTokens.clear();
    }

    public void visitNode(Tree tree) {
        this.ignoreMultipleOccurences = true;
    }

    public void leaveNode(Tree tree) {
        this.ignoreMultipleOccurences = false;
    }

    public void visitToken(SyntaxToken syntaxToken) {
        if (this.ignoreMultipleOccurences && !this.visitedTokens.add(syntaxToken)) {
            return;
        }
        int tokenLine = syntaxToken.line();
        if (tokenLine != this.previousTokenLine) {
            for (SyntaxTrivia trivia : syntaxToken.trivias()) {
                if (trivia.startLine() != this.previousTokenLine) continue;
                String comment = trivia.comment();
                String string = comment = comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
                if (this.pattern.matcher(comment = comment.trim()).matches() || TrailingCommentCheck.containsExcludedPattern(comment)) continue;
                this.addIssue(this.previousTokenLine, "Move this trailing comment on the previous empty line.");
            }
        }
        this.previousTokenLine = tokenLine;
    }

    private static boolean containsExcludedPattern(String comment) {
        for (String excludePattern : EXCLUDED_PATTERNS) {
            if (!StringUtils.containsIgnoreCase((String)comment, (String)excludePattern)) continue;
            return true;
        }
        return false;
    }
}

