/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2093", name="Try-with-resources should be used", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class TryWithResourcesCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private final Deque<TryStatementTree> withinTry = new LinkedList<TryStatementTree>();
    private final Deque<List<Tree>> toReport = new LinkedList<List<Tree>>();

    protected void scanTree(Tree tree) {
        super.scanTree(tree);
        this.withinTry.clear();
        this.toReport.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRY_STATEMENT, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
            this.withinTry.push((TryStatementTree)tree);
            this.toReport.push(new ArrayList());
        } else if (this.withinStandardTryWithFinally() && ((NewClassTree)tree).symbolType().isSubtypeOf("java.lang.AutoCloseable")) {
            this.toReport.peek().add(tree);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
            TryStatementTree tryStatementTree = this.withinTry.pop();
            List<Tree> secondaryTrees = this.toReport.pop();
            if (!secondaryTrees.isEmpty()) {
                ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
                for (Tree autoCloseable : secondaryTrees) {
                    secondary.add(new JavaFileScannerContext.Location("AutoCloseable resource", autoCloseable));
                }
                this.reportIssue((Tree)tryStatementTree.tryKeyword(), "Change this \"try\" to a try-with-resources." + this.context.getJavaVersion().java7CompatibilityMessage(), secondary, null);
            }
        }
    }

    private boolean withinStandardTryWithFinally() {
        return !this.withinTry.isEmpty() && this.withinTry.peek().resources().isEmpty() && this.withinTry.peek().finallyBlock() != null;
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isNotSet() || version.asInt() >= 7;
    }
}

